import pandas as pd


def run_classicstalta(data_array, nsta, nlta):

    data_series = pd.Series(data_array)                                  # convert array to Pandas Series
    lt_series = data_series[0:(len(data_series) - nsta + 1)]             # select elements for lta calculation
    st_series = data_series[(nlta - 1):(len(data_series))]               # select elements for sta calculation
    lta_ser = lt_series.rolling(window=nlta, min_periods=nlta).mean()    # LTA moving average
    sta_ser = st_series.rolling(window=nsta, min_periods=nsta).mean()    # STA moving average
    lta_series = lta_ser.dropna(ignore_index=True)                       # Remove nan values from LTA moving average
    sta_series = sta_ser.dropna(ignore_index=True)                       # Remove mean values from STA moving average
    stalta_ser = sta_series / lta_series                                 # STA - LTA ratio calculation
    stalta_series = stalta_ser.dropna(ignore_index=True)                 # Remove nan values from STA - LTA ratio series

    return stalta_series